//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import "GPIOUseCase.h"

@implementation GPIOUseCase: NSObject

#pragma mark - sharedInstance
+ (GPIOUseCase *) sharedInstance
{
    static GPIOUseCase *sharedInstance = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{ sharedInstance = [[GPIOUseCase alloc] init]; });
    return sharedInstance;
}

#pragma mark - readGPIO
- (void) readGPIO:(void (^)(NSData *aData, const int order) )success  onFailure : (void(^)(NSError *error))failure{
    // Read GPIO/PWM Config
    ISO15693Command *readGPIOPWMConfig = [[ISO15693Command alloc] initWithData:cmd_readGPIOPWMConfig];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: readGPIOPWMConfig onSuccess:^(NSData *aData){
        success(aData, 0);
    } onFailure:^(NSError *error) {
        NSLog(@"readGPIO error :\n%@", error.localizedDescription);
    }];
    
    // Read Tag Config
    ISO15693Command *readTagConfig = [[ISO15693Command alloc] initWithData:cmd_readTagConfig];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: readTagConfig onSuccess:^(NSData *aData){
        success(aData,1);
        [[NTAG5_NFC_LIB sharedInstance] setMessage:str_tag_correctly_read];
        [[NTAG5_NFC_LIB sharedInstance] close:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            NSLog(@"readGPIO error :\n%@", error.localizedDescription);
        }];
        
    } onFailure:^(NSError *error) {
        NSLog(@"readGPIO error :\n%@", error.localizedDescription);
    }];
}

#pragma mark - getGPIOInput
- (void) getGPIOInput:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    ISO15693Command *readTagStatus = [[ISO15693Command alloc] initWithData:cmd_readTagStatus];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: readTagStatus onSuccess:^(NSData *aData){
        success(aData);
        [[NTAG5_NFC_LIB sharedInstance] setMessage:str_tag_correctly_read];
        [[NTAG5_NFC_LIB sharedInstance] close:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            NSLog(@"getGPIOInput error :\n%@", error.localizedDescription);
        }];
    } onFailure:^(NSError *error) {
         NSLog(@"getGPIOInput error :\n%@", error.localizedDescription);
    }];
}

#pragma mark - clearGPIOOutput
- (void) clearGPIOOutput:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    ISO15693Command *gpioClearSessionOutput = [[ISO15693Command alloc] initWithData:cmd_gpioClearSessionOutput];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: gpioClearSessionOutput onSuccess:^(NSData *aData){
        success(aData);
        
        [[NTAG5_NFC_LIB sharedInstance] setMessage:str_register_correctly_clear];
        [[NTAG5_NFC_LIB sharedInstance] close:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
             NSLog(@"clearGPIOOutput error :\n%@", error.localizedDescription);
        }];
        
    } onFailure:^(NSError *error) {
        NSLog(@"clearGPIOOutput error :\n%@", error.localizedDescription);
    }];
}

#pragma mark - pushGPIOOutput
- (void) pushGPIOOutput:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    ISO15693Command *gpioSetSessionOutput = [[ISO15693Command alloc] initWithData:cmd_gpioSetSessionOutput];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: gpioSetSessionOutput onSuccess:^(NSData *aData){
        success(aData);
        
        [[NTAG5_NFC_LIB sharedInstance] setMessage:str_register_correctly_set];
        [[NTAG5_NFC_LIB sharedInstance] close:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            NSLog(@"pushGPIOOutput error :\n%@", error.localizedDescription);
        }];
        
    } onFailure:^(NSError *error) {
        NSLog(@"pushGPIOOutput error :\n%@", error.localizedDescription);
    }];
}

#pragma mark - writeGPIO
- (void) writeGPIO: (ISO15693Command *)getTagConfig getTagConfig: (ISO15693Command *) getTagSession onSuccess:(void (^)(NSData *aData))success  onFailure : (void(^)(NSError *error))failure{
    // Write Tag Configuration
    ISO15693Command *writeGPIOConfig = [[ISO15693Command alloc] initWithData:cmd_writeGPIOConfig];
    
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: writeGPIOConfig onSuccess:^(NSData *aData){
        
    } onFailure:^(NSError *error) {
        NSLog(@"writeGPIO error :\n%@", error.localizedDescription);
    }];
    
    // Write GPIO Session Register
    ISO15693Command *writeGPIOSession = [[ISO15693Command alloc] initWithData:cmd_writeGPIOSession];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: writeGPIOSession onSuccess:^(NSData *aData){
        
    } onFailure:^(NSError *error) {
        NSLog(@"writeGPIO error :\n%@", error.localizedDescription);
    }];
    
    // Get Tag Configuration
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: getTagConfig onSuccess:^(NSData *aData){
        
    } onFailure:^(NSError *error) {
        NSLog(@"writeGPIO error :\n%@", error.localizedDescription);
    }];
    
    // Get Tag Session Register
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: getTagSession onSuccess:^(NSData *aData){
        success(aData);
        
        [[NTAG5_NFC_LIB sharedInstance] setMessage:str_tag_correctly_read];
        [[NTAG5_NFC_LIB sharedInstance] close:^(NSData *aData) {
            
        } onFailure:^(NSError *error) {
            NSLog(@"writeGPIO error :\n%@", error.localizedDescription);
        }];
        
    } onFailure:^(NSError *error) {
        NSLog(@"writeGPIO error :\n%@", error.localizedDescription);
    }];
}

@end
